@extends('layouts.app')

@section('title', 'Edit Profile')

@section('content')
<div class="container mx-auto">
    <h1 class="text-2xl font-bold mb-4">Edit Profile</h1>

    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <form method="POST" action="{{ route('profile.update') }}">
        @csrf
        @method('PATCH')

        <div class="mb-4">
            <label for="name" class="form-label">Name</label>
            <input type="text" id="name" name="name" class="form-control" value="{{ old('name', $user->name) }}" required>
            @error('name')
                <div class="text-danger">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-4">
            <label for="email" class="form-label">Email</label>
            <input type="email" id="email" name="email" class="form-control" value="{{ old('email', $user->email) }}" required>
            @error('email')
                <div class="text-danger">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-4">
            <label for="password" class="form-label">New Password</label>
            <input type="password" id="password" name="password" class="form-control">
            @error('password')
                <div class="text-danger">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-4">
            <label for="password_confirmation" class="form-label">Confirm New Password</label>
            <input type="password" id="password_confirmation" name="password_confirmation" class="form-control">
        </div>

        <div class="mb-3">
            <label for="business_name" class="form-label">Business Name</label>
            <input type="text" class="form-control" id="business_name" name="business_name" value="{{ old('business_name', $profile->business_name) }}">
        </div>

        <div class="mb-3">
            <label for="contact_name" class="form-label">Contact Name</label>
            <input type="text" class="form-control" id="contact_name" name="contact_name" value="{{ old('contact_name', $profile->contact_name) }}">
        </div>

        <div class="mb-3">
            <label for="phone_number" class="form-label">Phone Number</label>
            <input type="text" class="form-control" id="phone_number" name="phone_number" value="{{ old('phone_number', $profile->phone_number) }}">
        </div>

        <div class="mb-3">
            <label for="address_line1" class="form-label">Address Line 1</label>
            <input type="text" class="form-control" id="address_line1" name="address_line1" value="{{ old('address_line1', $profile->address_line1) }}">
        </div>

        <div class="mb-3">
            <label for="address_line2" class="form-label">Address Line 2</label>
            <input type="text" class="form-control" id="address_line2" name="address_line2" value="{{ old('address_line2', $profile->address_line2) }}">
        </div>

        <div class="mb-3">
            <label for="city" class="form-label">City</label>
            <input type="text" class="form-control" id="city" name="city" value="{{ old('city', $profile->city) }}">
        </div>

        <div class="mb-3">
            <label for="state" class="form-label">State</label>
            <input type="text" class="form-control" id="state" name="state" value="{{ old('state', $profile->state) }}">
        </div>

        <div class="mb-3">
            <label for="zip_code" class="form-label">Zip Code</label>
            <input type="text" class="form-control" id="zip_code" name="zip_code" value="{{ old('zip_code', $profile->zip_code) }}">
        </div>

        <div class="mb-3">
            <label for="country" class="form-label">Country</label>
            <input type="text" class="form-control" id="country" name="country" value="{{ old('country', $profile->country) }}">
        </div>

        <div class="mb-3">
            <label for="business_license_number" class="form-label">Business License Number</label>
            <input type="text" class="form-control" id="business_license_number" name="business_license_number" value="{{ old('business_license_number', $profile->business_license_number) }}">
        </div>

        <div class="mb-3">
            <label for="incorporation_details" class="form-label">Incorporation Details</label>
            <textarea class="form-control" id="incorporation_details" name="incorporation_details" rows="3">{{ old('incorporation_details', $profile->incorporation_details) }}</textarea>
        </div>

        <button type="submit" class="btn btn-primary">Update Profile</button>
    </form>

    <form method="POST" action="{{ route('profile.destroy') }}" class="mt-4">
        @csrf
        @method('DELETE')
        <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete your account? This action cannot be undone.')">Delete Account</button>
    </form>
</div>
@endsection